/*
* Includes
*/
#include <stdlib.h>
#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "adelay.h"

#define OUTPUT_PORT PORTD
#define IROUT_BIT PD7

//PortD Output
/****************************************/
/****************************************/
/****** Variable Definitions     ********/
/****************************************/
/****************************************/
uint8_t count=0;	//count loop timer for shoot function

//io init
void init_io(void)
{
	//All Ouputs on
	DDRD = 0xff;
	DDRC |= ( 1 << PC1);
}

void shoot(void)
{
		for(count=0; count <=77; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(13);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(13);
		}
	
		Delay_us(27830); //wait pulse
		
		//15*2*13 = 390 = second on pulse
		for(count=0; count <=15; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(13);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(13);
		}
		
		Delay_us(1580); //wait pulse
		
		//15*2*16 = 403 = third on pulse (need 410 so we put another on cycle in at the end and add the off time to the next delay)
		for(count=0; count <=15; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(13);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(13);
		}
		
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(13);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		
		//wait pulse (plus last 7us from previous wait)
		Delay_us(3587); 
		
		//15*2*16 = 403 = third on pulse (should be 400, but three microseconds won't matter much!)
		for(count=0; count <=15; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(13);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(13);
		}
}

int main(void)
{
	init_io();
	OUTPUT_PORT &= ~(1 << IROUT_BIT);
	while(1)
	{
		PORTC |= (1 << PC1);
		Delay_ms(1000);
		PORTC &= ~(1 << PC1);
		shoot();
		Delay_ms(63);
		shoot();
		Delay_ms(5000);
	}
	return 1;
}